/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.inconn;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigData;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigEvent;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigListener;
import com.ibm.hwmca.fw.rcs.inconn.InboundConnectivityConstants;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.ProblemDataBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class InboundConfigManager
implements InboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSICMT";
    private static final String TRACE_MASKF = "XRCSICMF";
    private static final String TRACE_MASKD = "XRCSICMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-IbCfgMgr");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.fw.rcs.inconn.InboundConfigData";
    private static InboundConfigManager inboundConfigMgr = null;
    private Object dataLock = new Object();
    private List listeners = new ArrayList();
    private Object listenersLock = new Object();

    private InboundConfigManager() {
        Trace.trace(TRACE_MASKT, "<> InboundConfigManager()");
    }

    public static synchronized InboundConfigManager getInboundConfigManager() {
        Trace.trace(TRACE_MASKT, "-> getInboundConfigManager()");
        if (inboundConfigMgr == null) {
            inboundConfigMgr = new InboundConfigManager();
        }
        Trace.trace(TRACE_MASKT, "<- getInboundConfigManager()");
        return inboundConfigMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInboundConfigListener(InboundConfigListener listener) {
        Trace.trace(TRACE_MASKT, "-> addInboundConfigListener()");
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
        Trace.trace(TRACE_MASKT, "<- addInboundConfigListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInboundConfigListener(InboundConfigListener listener) {
        Trace.trace(TRACE_MASKT, "-> removeInboundConfigListener()");
        Object object = this.listenersLock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- removeInboundConfigListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundConfigData getInboundConfig() {
        Trace.trace(TRACE_MASKT, "-> getInboundConfig()");
        InboundConfigData inboundConfigData = null;
        Object object = this.dataLock;
        synchronized (object) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    inboundConfigData = (InboundConfigData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    new FrameworkLog(classLogInfo, 1938, pe).log();
                    inboundConfigData = new InboundConfigData();
                }
            } else {
                inboundConfigData = new InboundConfigData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getInboundConfig()");
        return inboundConfigData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInboundConfig(InboundConfigData data) {
        Trace.trace(TRACE_MASKT, "-> setInboundConfig()");
        Trace.trace(TRACE_MASKF, data.toString());
        Object object = this.dataLock;
        synchronized (object) {
            try {
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, data);
                Object object2 = this.listenersLock;
                synchronized (object2) {
                    if (this.listeners.size() > 0) {
                        InboundConfigData dataCopy = this.getInboundConfig();
                        InboundConfigEvent event = new InboundConfigEvent(this, 1, dataCopy);
                        Iterator iterator = this.listeners.iterator();
                        while (iterator.hasNext()) {
                            InboundConfigListener listener = (InboundConfigListener)iterator.next();
                            String className = listener.getClass().getName();
                            Trace.trace(TRACE_MASKF, "-> " + className + ".inboundConfigChanged()");
                            listener.inboundConfigChanged(event);
                            Trace.trace(TRACE_MASKF, "<- " + className + ".inboundConfigChanged()");
                        }
                    }
                }
            }
            catch (PersistenceException pe) {
                new FrameworkLog(classLogInfo, 1938, pe).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- setInboundConfig()");
    }

    public boolean isUnattendedServiceAllowedNow() {
        Trace.trace(TRACE_MASKT, "-> isUnattendedServiceAllowedNow()");
        boolean isAllowed = false;
        Date now = new Date();
        InboundConfigData inCfgData = this.getInboundConfig();
        Trace.trace(TRACE_MASKF, "now=" + now);
        Trace.trace(TRACE_MASKF, inCfgData.toString());
        if (inCfgData.isAllowUnattendedService()) {
            int durationType = inCfgData.getUnattendedDurationType();
            if (durationType == 0) {
                isAllowed = true;
            } else if (durationType == 1) {
                long lastProblemOpenTime = ProblemDataBase.getLastProblemOpenTime();
                if (lastProblemOpenTime > 0L) {
                    int autoDays = inCfgData.getUnattendedAutoDays();
                    Date lastProblemOpen = new Date(lastProblemOpenTime);
                    Date expiration = new Date(lastProblemOpen.getTime() + (long)(autoDays * 86400000));
                    Trace.trace(TRACE_MASKF, "lastProblemOpen=" + lastProblemOpen);
                    Trace.trace(TRACE_MASKF, "expiration=" + expiration);
                    if (now.before(expiration)) {
                        isAllowed = true;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "No open problems");
                }
            } else if (durationType == 2) {
                Date tempStart = inCfgData.getUnattendedTempStart();
                Date tempEnd = inCfgData.getUnattendedTempEnd();
                if (tempStart != null && tempEnd != null && now.after(tempStart) && now.before(tempEnd)) {
                    isAllowed = true;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- isUnattendedServiceAllowedNow() " + isAllowed);
        return isAllowed;
    }

    public static class SaveRestore
    implements CustomizableData {
        public SaveRestore() {
            Trace.trace(InboundConfigManager.TRACE_MASKT, "<> SaveRestore");
        }

        public UIInfo getUIInfo() {
            LocalizableText name = new LocalizableText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", "DATA_NAME");
            LocalizableText caption = new LocalizableText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", "DATA_CAPTION");
            return new UIInfo(name, caption);
        }

        public Serializable getSaveableData() {
            Trace.trace(InboundConfigManager.TRACE_MASKT, "-> getSaveableData()");
            InboundConfigManager cfgMgr = InboundConfigManager.getInboundConfigManager();
            InboundConfigData inConfigData = cfgMgr.getInboundConfig();
            Trace.trace(InboundConfigManager.TRACE_MASKF, inConfigData.toString());
            Trace.trace(InboundConfigManager.TRACE_MASKT, "<- getSaveableData()");
            return inConfigData.getPersistentData();
        }

        public void restoreData(Serializable obj) {
            Trace.trace(InboundConfigManager.TRACE_MASKT, "-> restoreData()");
            try {
                PersistentData persistentData = (PersistentData)obj;
                InboundConfigData inConfigData = new InboundConfigData(persistentData);
                InboundConfigManager cfgMgr = InboundConfigManager.getInboundConfigManager();
                cfgMgr.setInboundConfig(inConfigData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.trace(InboundConfigManager.TRACE_MASKT, "<- restoreData()");
        }

        public String getCustomDataKey() {
            return InboundConfigManager.PERSISTENCE_NAME;
        }
    }
}

